
import logging

import grpc

from perxis.auth import APIKeyPlugin
from perxis.spaces import spaces_pb2, spaces_pb2_grpc

SPACE_ID = 'c2qcp9cuaccmpj8lmom0'


def get(stub, space_id):
    return stub.Get.with_call(
        spaces_pb2.GetRequest(space_id=space_id),
    )


def main() -> None:
    auth_plugin = APIKeyPlugin(
        token="0Xp7bYBqYmIUqwZcNRMtRCtDBaheFdAc"
    )

    call_credentials = grpc.metadata_call_credentials(auth_plugin, name='auth')
    channel_credentials = grpc.ssl_channel_credentials()
    composite_credentials = grpc.composite_channel_credentials(
        channel_credentials, call_credentials
    )

    with grpc.secure_channel('envoy.perxis.pt.perx.ru:443', composite_credentials) as channel:
        stub = spaces_pb2_grpc.SpacesStub(channel)
        print('---------- GET ----------')
        response, state = get(stub, SPACE_ID)
        print(response.space, state)


if __name__ == '__main__':
    logging.basicConfig(level=logging.INFO)
    main()
