
import logging

import grpc

from perxis.auth import APIKeyPlugin
from perxis.items import items_pb2, items_pb2_grpc
from google.protobuf.struct_pb2 import Struct


SPACE_ID = 'c2qcp9cuaccmpj8lmom0'
ENV_ID = 'master'
COLL_ID = 'test_eterevskiy'


def create(stub, space_id, env_id, coll_id, data):
    return stub.Create.with_call(
        items_pb2.CreateRequest(item=items_pb2.Item(
               space_id=space_id, env_id=env_id, collection_id=coll_id, data=data
        )),
    )


def get(stub, space_id, env_id, coll_id, item_id):
    return stub.Get.with_call(
        items_pb2.GetRequest(
            space_id=space_id, env_id=env_id, collection_id=coll_id, item_id=item_id
        ),
    )


def find(stub, space_id, env_id, coll_id, filter=None):
    return stub.Find.with_call(
        items_pb2.FindRequest(space_id=space_id, env_id=env_id, collection_id=coll_id, filter=filter),
    )


def update(stub, space_id, env_id, coll_id, item_id, data):
    return stub.Update.with_call(
        items_pb2.UpdateRequest(
            item=items_pb2.Item(space_id=space_id, env_id=env_id, collection_id=coll_id, id=item_id, data=data)
        ),
    )


def main() -> None:
    auth_plugin = APIKeyPlugin(
        token="0Xp7bYBqYmIUqwZcNRMtRCtDBaheFdAc"
    )

    call_credentials = grpc.metadata_call_credentials(auth_plugin, name='auth')
    channel_credentials = grpc.ssl_channel_credentials()
    composite_credentials = grpc.composite_channel_credentials(
        channel_credentials, call_credentials
    )

    with grpc.secure_channel('envoy.perxis.pt.perx.ru:443', composite_credentials) as channel:
        stub = items_pb2_grpc.ItemsStub(channel)
        print('---------- CREATE ----------')
        data = Struct()
        data.update({'title': 'test'})
        response, state = create(stub, SPACE_ID, ENV_ID, COLL_ID, data)
        created = response.created
        print(response.created, state)
        print('---------- GET ----------')
        response, state = get(stub, SPACE_ID, ENV_ID, COLL_ID, created.id)
        print(response.item, state)
        print('---------- FIND ----------')
        response, state = find(stub, SPACE_ID, ENV_ID, COLL_ID)
        print(response.items, state)
        print('---------- UPDATE ----------')
        data = Struct()
        data.update({'title': 'New test title'})
        response, state = update(stub, SPACE_ID, ENV_ID, COLL_ID, created.id, data)
        print(state)


if __name__ == '__main__':
    logging.basicConfig(level=logging.INFO)
    main()
