from constants import extension
from constants import collections


from perxis.extensions.extension_service import ExtensionService
from perxis.collections import helpers as collections_helpers
from perxis.roles import roles_pb2
from perxis.common import common_pb2
from perxis.clients import clients_pb2


class Servicer(ExtensionService):
    extension_id = extension.ID
    collections = collections_helpers.make_collection_instances("./schemes", collections.schemes_mapping)
    roles = [
        roles_pb2.Role(
            id="demo-role",
            description="Описание к роли",
            rules=[
                common_pb2.Rule(
                    collection_id="dealers_cities",
                    actions=[common_pb2.CREATE, common_pb2.UPDATE, common_pb2.DELETE],
                )
            ],
            environments=["*"],
            allow_management=False,
        )
    ]
    clients = [
        clients_pb2.Client(
            id="demo-client",
            name="Демонстрационный клиент",
            description="Описание созданного расширением клиента",
            role_id="demo-role",
            api_key={
                "rotate": True
            }
        )
    ]
