
import logging

import grpc

from perxis.auth import APIKeyPlugin
from perxis.environments import environments_pb2, environments_pb2_grpc

SPACE_ID = 'c2qcp9cuaccmpj8lmom0'


def create(stub, space_id, description):
    return stub.Create.with_call(
        environments_pb2.CreateRequest(env=environments_pb2.Environment(
            space_id=space_id,
            description=description
        )),
    )


def get(stub, space_id, env_id):
    return stub.Get.with_call(
        environments_pb2.GetRequest(space_id=space_id, env_id=env_id),
    )


def list(stub, space_id) -> tuple:
    return stub.List.with_call(
        environments_pb2.ListRequest(space_id=space_id),
    )


def update(stub, space_id, env_id, description):
    return stub.Update.with_call(
        environments_pb2.UpdateRequest(env=environments_pb2.Environment(
            space_id=space_id,
            id=env_id,
            description=description
        )),
    )


def set_alias(stub, space_id, env_id, alias):
    return stub.SetAlias.with_call(
        environments_pb2.SetAliasRequest(
            space_id=space_id,
            env_id=env_id,
            alias=alias
        ),
    )


def remove_alias(stub, space_id, env_id, alias):
    return stub.SetAlias.with_call(
        environments_pb2.RemoveAliasRequest(
            space_id=space_id,
            env_id=env_id,
            alias=alias
        ),
    )


def delete(stub, space_id, env_id) -> tuple:
    return stub.Delete.with_call(
        environments_pb2.DeleteRequest(space_id=space_id, env_id=env_id),
    )


def main() -> None:
    auth_plugin = APIKeyPlugin(
        token="0Xp7bYBqYmIUqwZcNRMtRCtDBaheFdAc"
    )

    call_credentials = grpc.metadata_call_credentials(auth_plugin, name='auth')
    channel_credentials = grpc.ssl_channel_credentials()
    composite_credentials = grpc.composite_channel_credentials(
        channel_credentials, call_credentials
    )

    with grpc.secure_channel('envoy.perxis.pt.perx.ru:443', composite_credentials) as channel:
        stub = environments_pb2_grpc.EnvironmentsStub(channel)
        print('---------- CREATE ----------')
        response, state = create(stub, SPACE_ID, 'test description')
        created = response.created
        print(response.created, state)
        print('---------- GET ----------')
        response, state = get(stub, SPACE_ID, created.id)
        print(response.env, state)
        print('---------- LIST ----------')
        response, state = list(stub, SPACE_ID)
        print(response.envs, state)
        print('---------- UPDATE ----------')
        response, state = update(stub, SPACE_ID, created.id, 'new test description')
        print(state)
        print('---------- SET ALIAS ----------')
        response, state = set_alias(stub, SPACE_ID, created.id, 'test_alias')
        print(state)
        print('---------- REMOVE ALIAS ----------')
        response, state = remove_alias(stub, SPACE_ID, created.id, 'test_alias')
        print(state)
        print('---------- DELETE ----------')
        response, state = delete(stub, SPACE_ID, created.id)
        print(state)


if __name__ == '__main__':
    logging.basicConfig(level=logging.INFO)
    main()
