
import logging

import grpc

from perxis.auth import APIKeyPlugin
from perxis.collections import collections_pb2, collections_pb2_grpc


SPACE_ID = 'c2qcp9cuaccmpj8lmom0'
ENV_ID = "master"


def create(stub, space_id, env_id, coll_id, name):
    return stub.Create.with_call(
        collections_pb2.CreateRequest(collection=collections_pb2.Collection(space_id=space_id, env_id=env_id, id=coll_id, name=name)),
    )


def get(stub, space_id, env_id, coll_id):
    return stub.Get.with_call(
        collections_pb2.GetRequest(space_id=space_id, env_id=env_id, collection_id=coll_id),
    )


def list(stub, space_id, env_id):
    return stub.List.with_call(
        collections_pb2.ListRequest(space_id=space_id, env_id=env_id),
    )


def update(stub, space_id, env_id, coll_id, name):
    return stub.Update.with_call(
        collections_pb2.UpdateRequest(
            collection=collections_pb2.Collection(space_id=space_id, env_id=env_id, id=coll_id, name=name)),
    )


def delete(stub, space_id, env_id, coll_id):
    return stub.Delete.with_call(
        collections_pb2.DeleteRequest(space_id=space_id, env_id=env_id, collection_id=coll_id),
    )


def main() -> None:
    auth_plugin = APIKeyPlugin(
        token="0Xp7bYBqYmIUqwZcNRMtRCtDBaheFdAc"
    )

    call_credentials = grpc.metadata_call_credentials(auth_plugin, name='auth')
    channel_credentials = grpc.ssl_channel_credentials()
    composite_credentials = grpc.composite_channel_credentials(
        channel_credentials, call_credentials
    )

    with grpc.secure_channel('envoy.perxis.pt.perx.ru:443', composite_credentials) as channel:
        stub = collections_pb2_grpc.CollectionsStub(channel)
        print('---------- CREATE ----------')
        response, state = create(stub, SPACE_ID, ENV_ID, 'test_coll_id', 'test collection name')
        print(response.created, state)
        created = response.created
        print('---------- GET ----------')
        response, state = get(stub, SPACE_ID, ENV_ID, created.id)
        print(response.collection, state)
        print('---------- LIST ----------')
        response, state = list(stub, SPACE_ID, ENV_ID)
        print(response.collections, state)
        print('---------- UPDATE ----------')
        response, state = update(stub, SPACE_ID, ENV_ID, created.id, 'new test collection name')
        print(state)
        print('---------- DELETE ----------')
        response, state = delete(stub, SPACE_ID, ENV_ID, created.id)
        print(state)


if __name__ == '__main__':
    logging.basicConfig(level=logging.INFO)
    main()
