import logging

import grpc
from oauthlib.oauth2 import BackendApplicationClient

from perxis.auth import APIKeyPlugin
from perxis.collections import collections_pb2, collections_pb2_grpc


def main():
    auth_plugin = APIKeyPlugin(
        token="0Xp7bYBqYmIUqwZcNRMtRCtDBaheFdAc"
    )

    call_credentials = grpc.metadata_call_credentials(auth_plugin, name='auth')
    channel_credentials = grpc.ssl_channel_credentials()
    composite_credentials = grpc.composite_channel_credentials(
            channel_credentials, call_credentials
    )
    with grpc.secure_channel('envoy.perxis.pt.perx.ru:443', composite_credentials) as channel:
        stub = collections_pb2_grpc.CollectionsStub(channel)
        collections = stub.List(collections_pb2.ListRequest(space_id="c2qcp9cuaccmpj8lmom0", env_id="master"))
        print(collections)


if __name__ == '__main__':
    logging.basicConfig(level=logging.INFO)
    main()
