package users

// Current - Идентификатор, который можно использовать для получения/обновления/регистрации
// пользователя, от имени которого был сделан запрос.
const Current = "current"

type User struct {
	ID            string   `json:"id" bson:"_id"`
	Name          string   `json:"name" bson:"name"`
	DisplayName   string   `json:"displayName" bson:"displayName"`
	Identities    []string `json:"identities" bson:"identities"`
	Email         string   `json:"email" bson:"email"`
	EmailVerified *bool    `json:"emailVerified" bson:"emailVerified"`
	AvatarURL     string   `json:"avatarUrl" bson:"avatarUrl,omitempty"`
	System        *bool    `json:"system" bson:"system"`
}

func (u User) GetID() string {
	return u.ID
}

func (u User) IsSystem() bool {
	if u.System != nil {
		return *u.System
	}
	return false
}

func (u User) Clone() *User {
	return &u
}
