package users

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

// @microgen grpc
// @protobuf git.perx.ru/perxis/perxis-go/proto/users
// @grpc-addr account.users.Users
type Users interface {
	Create(ctx context.Context, create *User) (user *User, err error)
	Get(ctx context.Context, userId string) (user *User, err error)
	Find(ctx context.Context, filter *Filter, options *options.FindOptions) (users []*User, total int, err error)
	Update(ctx context.Context, update *User) (err error)
	Delete(ctx context.Context, userId string) (err error)
	GetByIdentity(ctx context.Context, identity string) (user *User, err error)
}

type Filter struct {
	ID            []string
	Name          []string
	Identities    []string
	DisplayName   []string
	Email         []string
	AvatarUri     []string
	EmailVerified *bool
	System        *bool
}
