package transport

import (
	"bytes"
	"io"
	"net/http"
	"strings"

	jsoniter "github.com/json-iterator/go"
	"github.com/pkg/errors"
)

func DecodeError(r *http.Response) error {
	if r.StatusCode >= 200 && r.StatusCode < 300 {
		return nil
	}

	var buf bytes.Buffer
	if _, err := io.Copy(&buf, io.LimitReader(r.Body, 1024)); err != nil {
		return err
	}

	e := struct {
		Error error `json:"error"`
	}{}
	if err := jsoniter.Unmarshal(buf.Bytes(), e); err != nil {
		msg := strings.TrimSpace(buf.String())
		if msg == "" {
			msg = http.StatusText(r.StatusCode)
		}
		return errors.New(msg)
	}

	return e.Error
}
