package transportgrpc

import (
	grpcerr "git.perx.ru/perxis/perxis-go/pkg/errors/grpc"
	"git.perx.ru/perxis/perxis-go/pkg/spaces"
	"git.perx.ru/perxis/perxis-go/pkg/spaces/transport"
	pb "git.perx.ru/perxis/perxis-go/proto/spaces"
	grpckit "github.com/go-kit/kit/transport/grpc"
)

func NewServer(svc spaces.Spaces, opts ...grpckit.ServerOption) pb.SpacesServer {
	eps := transport.Endpoints(svc)
	eps = transport.EndpointsSet{
		CreateEndpoint:        grpcerr.ServerMiddleware(eps.CreateEndpoint),
		GetEndpoint:           grpcerr.ServerMiddleware(eps.GetEndpoint),
		ListEndpoint:          grpcerr.ServerMiddleware(eps.ListEndpoint),
		UpdateEndpoint:        grpcerr.ServerMiddleware(eps.UpdateEndpoint),
		UpdateConfigEndpoint:  grpcerr.ServerMiddleware(eps.UpdateConfigEndpoint),
		DeleteEndpoint:        grpcerr.ServerMiddleware(eps.DeleteEndpoint),
		TransferEndpoint:      grpcerr.ServerMiddleware(eps.TransferEndpoint),
		AbortTransferEndpoint: grpcerr.ServerMiddleware(eps.AbortTransferEndpoint),
		MoveEndpoint:          grpcerr.ServerMiddleware(eps.MoveEndpoint),
		ListTransfersEndpoint: grpcerr.ServerMiddleware(eps.ListTransfersEndpoint),
	}
	return NewGRPCServer(&eps, opts...)
}
