package spaces

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

type Storage interface {
	Create(ctx context.Context, space *Space) error
	Find(ctx context.Context, filter *Filter, opts *options.FindOptions) (spaces []*Space, total int, err error)
	Delete(ctx context.Context, filter *Filter) (total int, err error)
	Update(ctx context.Context, update *Space, filter *Filter) (updated, total int, err error)
	Reset(ctx context.Context) error
	Init(ctx context.Context) error
}

type Filter struct {
	ID            []string `json:"id,omitempty" bson:"_id"`
	OrgID         []string `json:"org_id,omitempty" bson:"orgId"`
	Name          []string `json:"name,omitempty" bson:"name"`
	State         []State  `json:"state,omitempty" bson:"state"`
	TransferToOrg []string `json:"transfer_to_org" bson:"transfer_to_org"`
}
