package spaces

type State int

const (
	StateUnknown     State = iota
	StateNew               // Новое пространство, БД еще не инициализирована
	StateReady             // Пространство готово к использованию
	StatePreparing         // Пространство готовится в использованию
	StateMaintenance       // Пространство находится на обслуживании
	StateMigration         // Пространство в состоянии выполнения миграций
	StateDeleting          // Пространство удаляется, данные будут удалены
	StateError             // Произошла ошибка при конфигурации пространства (см. Space.Error)
)

type Config struct {
	Features []string //Deprecated Возможности используемые пространством
}

const StateInfoEmpty = "EMPTY"

type Space struct {
	ID          string `json:"id,omitempty" bson:"_id"`
	OrgID       string `json:"org_id,omitempty" bson:"org_id"`
	Name        string `json:"name,omitempty" bson:"name"`
	Description string `json:"desc,omitempty" bson:"desc"`
	State       State  `json:"state" bson:"state"`
	StateInfo   string `json:"stateInfo,omitempty" bson:"stateInfo,omitempty"`

	// TransferToOrg - идентификатор организации, в которую был запрошен перенос пространства
	TransferToOrg string `json:"transfer_to_org" bson:"transfer_to_org"`

	Config *Config `json:"config" bson:"config"`
}

func (s Space) Clone() *Space {
	return &s
}

func (s Space) Fetch(i interface{}) interface{} {
	p, _ := i.(string)
	switch p {
	case "ID":
		return s.ID
	case "OrgID":
		return s.OrgID
	case "Name":
		return s.Name
	case "Description":
		return s.Description
	case "State":
		return s.State
	case "Config":
		return s.Config
	default:
		panic("unknown parameter")
	}
}
