package schemaloader

import (
	"context"
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
)

//func Test_Load(t *testing.T) {
//
//	const (
//		spaceID = "SpaceID"
//		envID   = "envID"
//		colID   = "colID"
//		uri     = "/colID#fieldID"
//	)
//
//	t.Run("Load schema (success)", func(t *testing.T) {
//		collSvs := &mocks.Collections{}
//
//		sch := schema.New(
//			"first_name", field.String(),
//			"last_name", field.String(),
//		)
//
//		cl := &collections.Collection{ID: colID, SpaceID: spaceID, EnvID: envID, Name: "Collection", Schema: sch}
//		collSvs.On("List", mock.Anything, spaceID, envID, mock.AnythingOfType("*collections.Filter")).Run(func(args mock.Arguments) {
//			filter := args[3].(*collections.Filter)
//
//			assert.Equal(t, &collections.Filter{ID: []string{"colID"}}, filter, "Фильтр должен содержать идентификатор коллекции")
//		}).Return([]*collections.Collection{cl}, nil).Once()
//
//		loader := NewLoader(collSvs, spaceID, envID)
//		schemas, err := loader.Load(nil, uri)
//
//		require.NoError(t, err, "Ожидается успешное завершение")
//		require.Equal(t, []*field.Field{&sch.Field}, schemas, "Метод должен возвращать срез схем")
//		collSvs.AssertExpectations(t)
//	})
//
//	t.Run("Collection doesn't have schema", func(t *testing.T) {
//		collSvs := &mocks.Collections{}
//
//		cl := &collections.Collection{ID: colID, SpaceID: spaceID, EnvID: envID, Name: "Collection"}
//		collSvs.On("List", mock.Anything, spaceID, envID, mock.AnythingOfType("*collections.Filter")).Run(func(args mock.Arguments) {
//			filter := args[3].(*collections.Filter)
//
//			assert.Equal(t, &collections.Filter{ID: []string{"colID"}}, filter, "Фильтр должен содержать идентификатор коллекции")
//		}).Return([]*collections.Collection{cl}, nil).Once()
//
//		loader := NewLoader(collSvs, spaceID, envID)
//		schemas, err := loader.Load(nil, uri)
//
//		require.Error(t, err, "Ожидается ошибка")
//		require.Contains(t, err.Error(), "schema not found")
//		require.Nil(t, schemas, "Метод должен вернуть nil")
//		//assert.Nil(t, schemas, "Метод должен вернуть nil")
//		collSvs.AssertExpectations(t)
//	})
//
//	t.Run("Loader not found collection", func(t *testing.T) {
//		collSvs := &mocks.Collections{}
//
//		collSvs.On("List", mock.Anything, spaceID, envID, mock.AnythingOfType("*collections.Filter")).Run(func(args mock.Arguments) {
//			filter := args[3].(*collections.Filter)
//
//			assert.Equal(t, &collections.Filter{ID: []string{"colID"}}, filter, "Фильтр должен содержать идентификатор коллекции")
//		}).Return([]*collections.Collection{}, nil).Once()
//
//		loader := NewLoader(collSvs, spaceID, envID)
//		schemas, err := loader.Load(nil, uri)
//
//		require.Error(t, err, "Ожидается ошибка")
//		require.Contains(t, err.Error(), "schema not found")
//		require.Nil(t, schemas, "Метод должен вернуть nil")
//		collSvs.AssertExpectations(t)
//	})
//
//	t.Run("Collection service return error", func(t *testing.T) {
//		collSvs := &mocks.Collections{}
//
//		collSvs.On("List", mock.Anything, spaceID, envID, mock.AnythingOfType("*collections.Filter")).Run(func(args mock.Arguments) {
//			filter := args[3].(*collections.Filter)
//
//			assert.Equal(t, &collections.Filter{ID: []string{"colID"}}, filter, "Фильтр должен содержать идентификатор коллекции")
//		}).Return(nil, errors.New("storage error")).Once()
//
//		loader := NewLoader(collSvs, spaceID, envID)
//		schemas, err := loader.Load(nil, uri)
//
//		require.Error(t, err, "Ожидается ошибка")
//		require.Contains(t, err.Error(), "failed to get schema")
//		require.Nil(t, schemas, "Метод должен вернуть nil")
//		collSvs.AssertExpectations(t)
//	})
//
//	t.Run("ParseMask return error", func(t *testing.T) {
//		collSvs := &mocks.Collections{}
//
//		loader := NewLoader(collSvs, spaceID, envID)
//		schemas, err := loader.Load(nil, "")
//
//		require.Error(t, err, "Ожидается ошибка")
//		require.Contains(t, err.Error(), "invalid schema reference")
//		require.Nil(t, schemas, "Метод должен вернуть nil")
//		collSvs.AssertExpectations(t)
//	})
//}

func Test_parseRef(t *testing.T) {
	ctx := WithContext(nil, &LoaderContext{SpaceID: "spc", EnvID: "env"})
	tests := []struct {
		ref            string
		ctx            context.Context
		wantSpaceID    string
		wantEnvId      string
		wantCollection string
		wantErr        assert.ErrorAssertionFunc
	}{
		{"col", ctx, "spc", "env", "col", assert.NoError},
		{"/col", ctx, "spc", "master", "col", assert.NoError},
		{"spc1/env1/col", ctx, "spc1", "env1", "col", assert.NoError},
		{"spc1/env1/col#fld", ctx, "spc1", "env1", "col", assert.NoError},
		{"col%3f*", ctx, "spc", "env", "col?*", assert.NoError},
		{"#fld", ctx, "spc", "env", "", assert.Error},
	}

	for _, tt := range tests {
		t.Run(tt.ref, func(t *testing.T) {
			gotSpaceID, gotEnvId, gotCollection, err := parseRef(tt.ctx, tt.ref)
			if !tt.wantErr(t, err, fmt.Sprintf("parseRef(%v)", tt.ref)) {
				return
			}
			assert.Equalf(t, tt.wantSpaceID, gotSpaceID, "parseRef(%v)", tt.ref)
			assert.Equalf(t, tt.wantEnvId, gotEnvId, "parseRef(%v)", tt.ref)
			assert.Equalf(t, tt.wantCollection, gotCollection, "parseRef(%v)", tt.ref)
		})
	}
}
