package schemaloader

import "context"

type LoaderContext struct {
	SpaceID string
	EnvID   string
}

type loaderCtxKey struct{}

func WithContext(ctx context.Context, loaderContext *LoaderContext) context.Context {
	if ctx == nil {
		ctx = context.Background()
	}
	p, _ := ctx.Value(loaderCtxKey{}).(*LoaderContext)
	if p != nil {
		*p = *loaderContext
		return ctx
	}
	return context.WithValue(ctx, loaderCtxKey{}, loaderContext)
}

func GetContext(ctx context.Context) *LoaderContext {
	p, _ := ctx.Value(loaderCtxKey{}).(*LoaderContext)
	if p == nil {
		return new(LoaderContext)
	}
	return p
}
