package validate

import (
	"testing"

	"git.perx.ru/perxis/perxis-go/pkg/schema/field"
	"github.com/stretchr/testify/require"
)

func TestEnum(t *testing.T) {
	stringEnum := Enum(
		EnumOpt{
			Name:  "N 1",
			Value: "n1",
		},
		EnumOpt{
			Name:  "N 2",
			Value: "n2",
		},
	)
	intEnum := Enum(
		EnumOpt{
			Name:  "N 1",
			Value: 1,
		},
		EnumOpt{
			Name:  "N 2",
			Value: 2,
		},
	)
	floatEnum := Enum(
		EnumOpt{
			Name:  "N 1",
			Value: 1.1,
		},
		EnumOpt{
			Name:  "N 2",
			Value: int(2),
		},
	)
	tests := []struct {
		name    string
		field   *field.Field
		data    interface{}
		wantErr bool
	}{
		{"Correct string", field.String(stringEnum), "n1", false},
		{"Correct int", field.Number(field.NumberFormatInt, intEnum), 1, false},
		{"Correct float", field.Number(field.NumberFormatFloat, floatEnum), 1.1, false},
		{"Correct float", field.Number(field.NumberFormatFloat, floatEnum), int(2), false},
		{"Incorrect string", field.String(stringEnum), "n3", true},
		{"Incorrect int", field.Number(field.NumberFormatInt, intEnum), 3, true},
		{"Incorrect float", field.Number(field.NumberFormatFloat, floatEnum), 1.0, true},
		{"Incorrect enum value", field.String(intEnum), "n1", true},
		{"Incorrect enum value", field.String(stringEnum).SetAdditionalValues(), "non enum value", false},
	}

	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := field.Decode(nil, tt.field, tt.data)
			require.NoError(t, err)
			err = Validate(nil, tt.field, got)
			if (err != nil) != tt.wantErr {
				t.Errorf("Validate() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
		})
	}
}
