package schema

import (
	"git.perx.ru/perxis/perxis-go/pkg/errors"
	jsoniter "github.com/json-iterator/go"
)

type jsonSchema struct {
	Loaded   bool              `json:"loaded"`
	Metadata map[string]string `json:"metadata"`
}

func (s *Schema) UnmarshalJSON(b []byte) error {

	var j *jsonSchema
	if err := jsoniter.Unmarshal(b, &j); err != nil {
		return errors.Wrapf(err, "error unmarshal json into field")
	}
	s.Loaded = j.Loaded
	s.Metadata = j.Metadata

	if err := s.Field.UnmarshalJSON(b); err != nil {
		return err
	}

	//if len(j.Field) > 0 {
	//	if err := s.Field.UnmarshalJSON(j.Field); err != nil {
	//		return err
	//	}
	//	//if err := jsoniter.Unmarshal(j.Field, &s.Field); err != nil {
	//	//	return err
	//	//}
	//}

	return nil
}

func (s *Schema) MarshalJSON() ([]byte, error) {

	jsonField, err := s.Field.MarshalJSON()
	if err != nil {
		return nil, err
	}

	jsonSch, err := jsoniter.Marshal(jsonSchema{
		Loaded:   s.Loaded,
		Metadata: s.Metadata,
	})
	if err != nil {
		return nil, err
	}
	jsonSch[0] = ',' // вместо такого можно сначала jsonField размаршалить в map[string]interface{}, добавить поле и замаршалить еще раз

	return append(jsonField[:len(jsonField)-1], jsonSch...), nil
}
