package field

import (
	"fmt"
	"reflect"
	"sync"
)

var (
	registry sync.Map
)

// Parameters - интерфейс который должен реализовывать параметр конкретного типа
type Parameters interface {
	Type() Type
	Clone(reset bool) Parameters
}

// Type - тип поля, отвечает за получение, кодирование и декодирование параметров для данного типа
type Type interface {
	Name() string
	NewParameters() Parameters
	//Encode(ctx *Context.Context, field *Field, v interface{}) (interface{}, error)
	//Decode(ctx *Context.Context, field *Field, v interface{}) (interface{}, error)
}

func Register(typ Type) {
	registry.Store(typ.Name(), typ)
}

func Unregister(typ interface{}) {
	switch t := typ.(type) {
	case Type:
		registry.Delete(t.Name())
	case string:
		registry.Delete(t)
	default:
		panic(fmt.Sprintf("unknown type: \"%s\"", reflect.ValueOf(t).Kind()))
	}
}

func GetType(name string) (Type, bool) {
	if i, ok := registry.Load(name); ok {
		return i.(Type), true
	}
	return nil, false
}
