package field

import (
	"reflect"
	"testing"
	"time"
)

func TestTimeField_Decode(t *testing.T) {
	w, _ := time.Parse(time.RFC3339, "2012-11-01T22:08:41Z")
	tests := []struct {
		name    string
		field   *Field
		data    interface{}
		want    interface{}
		wantErr bool
	}{
		{"Correct", Time(), "2012-11-01T22:08:41Z", w, false},
		{"Incorrect format", Time(), "2012-11-01", nil, true},
		{"Incorrect type", Time(), 2, nil, true},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := Decode(nil, tt.field, tt.data)
			if (err != nil) != tt.wantErr {
				t.Errorf("Decode() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !reflect.DeepEqual(got, tt.want) {
				t.Errorf("Decode() got = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestTimeField_Encode(t *testing.T) {
	w, _ := time.Parse(time.RFC3339, "2012-11-01T22:08:41Z")
	tests := []struct {
		name    string
		field   *Field
		data    interface{}
		want    interface{}
		wantErr bool
	}{
		{"Correct", Time(), w, "2012-11-01T22:08:41Z", false},
		{"Incorrect type string", Time(), "2012-11-01T22:08:41Z", nil, true},
		{"Incorrect type int", Time(), 2, nil, true},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := Encode(nil, tt.field, tt.data)
			if (err != nil) != tt.wantErr {
				t.Errorf("Encode() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !reflect.DeepEqual(got, tt.want) {
				t.Errorf("Encode() got = %v, want %v", got, tt.want)
			}
		})
	}
}
