package field

import (
	"context"
	"fmt"
	"reflect"
)

//TODO readonly

var primaryKeyType = &PrimaryKeyType{}

type PrimaryKeyParameters struct{}

func (p PrimaryKeyParameters) Type() Type                   { return primaryKeyType }
func (p *PrimaryKeyParameters) Clone(reset bool) Parameters { return p }

type PrimaryKeyType struct{}

func (p PrimaryKeyType) Name() string {
	return "PrimaryKey"
}

func (PrimaryKeyType) NewParameters() Parameters {
	return &PrimaryKeyParameters{}
}

func (PrimaryKeyType) IsEmpty(v interface{}) bool {
	s, _ := v.(string)
	return s == ""
}

func (PrimaryKeyType) Decode(_ context.Context, _ *Field, v interface{}) (interface{}, error) {
	if v == nil {
		return nil, nil
	}
	if _, ok := v.(string); ok {
		return v, nil
	}
	return nil, fmt.Errorf("PrimaryKeyField decode error: unsupported value type : \"%s\"", reflect.ValueOf(v).Kind())
}

func (PrimaryKeyType) Encode(_ context.Context, _ *Field, v interface{}) (interface{}, error) {
	if v == nil {
		return nil, nil
	}
	if _, ok := v.(string); ok {
		return v, nil
	}
	return nil, fmt.Errorf("PrimaryKeyField encode error: unsupported value type : \"%s\"", reflect.ValueOf(v).Kind())
}

func PrimaryKey(o ...interface{}) *Field {
	return NewField(&PrimaryKeyParameters{}, o...)
}
