package field

import (
	"context"
	"fmt"
)

// Loader интерфейс загрузчика схем
type Loader interface {
	Load(ctx context.Context, ref string) (fs []*Field, err error)
}

type LoaderFunc func(ref string) (fs []*Field, err error)

func (f LoaderFunc) Load(ctx context.Context, ref string) (fs []*Field, err error) {
	return f(ref)
}

type multiLoader struct {
	loaders []Loader
}

func (c *multiLoader) Load(ctx context.Context, ref string) (fs []*Field, err error) {
	for _, l := range c.loaders {
		if f, err := l.Load(nil, ref); err == nil {
			return f, nil
		}
	}
	return nil, fmt.Errorf("invalid schema reference: %s", ref)
}

func MultiLoader(loaders ...Loader) Loader {
	return &multiLoader{loaders: loaders}
}
