package field

import (
	"context"
	"fmt"
	"reflect"
)

var boolType = &BoolType{}

type BoolParameters struct{}

func (b BoolParameters) Type() Type                   { return boolType }
func (b *BoolParameters) Clone(reset bool) Parameters { return b }

type BoolType struct{}

func (b BoolType) Name() string {
	return "bool"
}

func (b BoolType) NewParameters() Parameters {
	return &BoolParameters{}
}
func (BoolType) IsEmpty(v interface{}) bool {
	return v == nil
}

func (b BoolType) Decode(_ context.Context, field *Field, v interface{}) (interface{}, error) {
	if v == nil {
		return v, nil
	}
	if _, ok := v.(bool); ok {
		return v, nil
	}
	return nil, fmt.Errorf("incorrect type: \"%s\", expected \"boolean\"", reflect.ValueOf(v).Kind())
}

func (b BoolType) Encode(_ context.Context, field *Field, v interface{}) (interface{}, error) {
	if v == nil {
		return v, nil
	}
	if _, ok := v.(bool); ok {
		return v, nil
	}
	return nil, fmt.Errorf("incorrect type: \"%s\", expected \"boolean\"", reflect.ValueOf(v).Kind())
}

func Bool(o ...interface{}) *Field {
	return NewField(&BoolParameters{}, o...)
}
