package field

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestArrayField_Decode(t *testing.T) {
	tests := []struct {
		name    string
		field   *Field
		data    interface{}
		want    interface{}
		wantErr bool
	}{
		{
			"Correct",
			Array(Number("float")),
			[]interface{}{1.0, 2.0},
			[]interface{}{1.0, 2.0},
			false,
		},
		{
			"Incorrect type",
			Array(Number("int")),
			"1 2 3",
			"decode error: incorrect type: \"string\", expected \"[]interface{}\"",
			true,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := Decode(nil, tt.field, tt.data)
			if tt.wantErr {
				require.Error(t, err)
				assert.EqualError(t, err, tt.want.(string), fmt.Sprintf("Decode() error = %v, want %v", err, tt.want.(string)))
			}
			if !tt.wantErr {
				require.NoError(t, err)
				assert.ElementsMatch(t, got, tt.want, fmt.Sprintf("Decode() got = %v, want %v", got, tt.want))
			}
		})
	}
}

func TestArrayField_Encode(t *testing.T) {
	tests := []struct {
		name    string
		field   *Field
		data    interface{}
		want    interface{}
		wantErr bool
	}{
		{
			"Correct",
			Array(Number("float")),
			[]interface{}{1.0, 2.0},
			[]interface{}{1.0, 2.0},
			false,
		},
		{
			"Incorrect type",
			Array(Number("int")),
			"1 2 3",
			"encode error: incorrect type: \"string\", expected \"[]interface{}\"",
			true,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got, err := Encode(nil, tt.field, tt.data)
			if tt.wantErr {
				require.Error(t, err)
				assert.EqualError(t, err, tt.want.(string), fmt.Sprintf("Decode() error = %v, want %v", err, tt.want.(string)))
			}
			if !tt.wantErr {
				require.NoError(t, err)
				assert.ElementsMatch(t, got, tt.want, fmt.Sprintf("Decode() got = %v, want %v", got, tt.want))
			}
		})
	}
}
