package references

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/items"
)

// @microgen grpc
// @protobuf git.perx.ru/perxis/perxis-go/proto/references
// @grpc-addr content.references.References
type References interface {
	Get(ctx context.Context, spaceId, envId string, references []*Reference) (items []*items.Item, notfound []*Reference, err error)

	Publish(ctx context.Context, spaceId, envId string, references []*Reference, recursive, force bool) (published []*Reference, notfound []*Reference, unpublished []*Reference, err error)
}
