package middleware

// DO NOT EDIT!
// This code is generated with http://github.com/hexdigest/gowrap tool
// using ../../../assets/templates/middleware/recovery template

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/references -i References -t ../../../assets/templates/middleware/recovery -o recovering_middleware.go

import (
	"context"
	"fmt"

	"git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/references"
	"go.uber.org/zap"
)

// recoveringMiddleware implements references.References that is instrumented with logging
type recoveringMiddleware struct {
	logger *zap.Logger
	next   references.References
}

// RecoveringMiddleware instruments an implementation of the references.References with simple logging
func RecoveringMiddleware(logger *zap.Logger) Middleware {
	return func(next references.References) references.References {
		return &recoveringMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *recoveringMiddleware) Get(ctx context.Context, spaceId string, envId string, references []*references.Reference) (items []*items.Item, notfound []*references.Reference, err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.Get(ctx, spaceId, envId, references)
}

func (m *recoveringMiddleware) Publish(ctx context.Context, spaceId string, envId string, references []*references.Reference, recursive bool, force bool) (published []*references.Reference, notfound []*references.Reference, unpublished []*references.Reference, err error) {
	logger := m.logger
	defer func() {
		if r := recover(); r != nil {
			logger.Error("panic", zap.Error(fmt.Errorf("%v", r)))
			err = fmt.Errorf("%v", r)
		}
	}()

	return m.next.Publish(ctx, spaceId, envId, references, recursive, force)
}
