package middleware

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/collections"
	"git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/references"
)

// ClientEncodeMiddleware выполняет операции encode/decode для передаваемых данных
func ClientEncodeMiddleware(colls collections.Collections) Middleware {
	return func(refs references.References) references.References {
		return &encodeDecodeMiddleware{
			next:  refs,
			colls: colls,
		}
	}
}

type encodeDecodeMiddleware struct {
	next  references.References
	colls collections.Collections
}

func (m *encodeDecodeMiddleware) Get(ctx context.Context, spaceId, envId string, refs []*references.Reference) (items []*items.Item, notfound []*references.Reference, err error) {
	items, notfound, err = m.next.Get(ctx, spaceId, envId, refs)
	if err == nil && len(items) > 0 {
		for i, item := range items {
			col, err := m.colls.Get(ctx, item.SpaceID, item.EnvID, item.CollectionID)
			if err != nil {
				return nil, nil, err
			}

			if item, err = item.Decode(ctx, col.Schema); err != nil {
				return nil, nil, err
			}
			items[i] = item
		}
	}
	return
}

func (m *encodeDecodeMiddleware) Publish(ctx context.Context, spaceId string, envId string, references []*references.Reference, recursive bool, force bool) (published []*references.Reference, notfound []*references.Reference, unpublished []*references.Reference, err error) {
	return m.next.Publish(ctx, spaceId, envId, references, recursive, force)
}
