package permission

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestMerge(t *testing.T) {
	const (
		col1 = "colID"
		col2 = "colViewID"
	)

	tests := []struct {
		name                  string
		first, second, expect *Rule
	}{
		{
			name:   "simple",
			first:  &Rule{Actions: []Action{ActionUpdate, ActionCreate}, CollectionID: col1, HiddenFields: []string{"1", "2"}, WriteonlyFields: []string{"7"}, ReadonlyFields: []string{"4"}, ReadFilter: "3 != 'test'", WriteFilter: "4 == '0_0'"},
			second: &Rule{Actions: []Action{ActionUpdate, ActionDelete}, CollectionID: col2, HiddenFields: []string{"3", "2"}, WriteonlyFields: []string{}, ReadonlyFields: []string{"5"}, ReadFilter: "5 != 'dev'", WriteFilter: "4 == '0_0'"},
			expect: &Rule{Actions: []Action{ActionUpdate}, HiddenFields: []string{"1", "2", "3"}, WriteonlyFields: []string{"7"}, ReadonlyFields: []string{"4", "5"}, ReadFilter: "3 != 'test' && 5 != 'dev'", WriteFilter: "4 == '0_0'"},
		},
		{
			name:   "first is privileged",
			first:  PrivilegedRuleset{}.GetRule(col1),
			second: &Rule{Actions: []Action{ActionUpdate, ActionDelete}, CollectionID: col2, WriteFilter: "test"},
			expect: &Rule{Actions: []Action{ActionUpdate, ActionDelete}, WriteFilter: "test", ReadFilter: "", HiddenFields: []string{}, WriteonlyFields: []string{}, ReadonlyFields: []string{}},
		},
		{
			name:   "second is privileged",
			first:  &Rule{Actions: []Action{ActionUpdate, ActionDelete}, CollectionID: col1, WriteFilter: "test"},
			second: PrivilegedRuleset{}.GetRule(col2),
			expect: &Rule{Actions: []Action{ActionUpdate, ActionDelete}, WriteFilter: "test", ReadFilter: "", HiddenFields: []string{}, WriteonlyFields: []string{}, ReadonlyFields: []string{}},
		},
		{
			name:   "both is privileged",
			first:  PrivilegedRuleset{}.GetRule(col1),
			second: PrivilegedRuleset{}.GetRule(col2),
			expect: PrivilegedRuleset{}.GetRule(""),
		},
	}

	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			result := MergeRule(tt.first, tt.second)
			assert.Equal(t, tt.expect, result)
		})
	}
}
