package permission

import (
	"git.perx.ru/perxis/perxis-go/pkg/data"
	"git.perx.ru/perxis/perxis-go/pkg/expr"
)

type Access uint64

const (
	AccessAny  = iota // Access to any items (default)
	AccessMine        // Access to items owned by me (future use)
	AccessRole        // Access to items owned by my role (future use)
)

type Permission struct {
	Permitted       bool
	UnallowedFields []string
	Filter          string
}

func (p Permission) Can() bool {
	return p.Permitted
}

func Merge(pp ...*Permission) *Permission {

	res := new(Permission)

	var filters []string

	res.Permitted = true
	for _, p := range pp {
		res.Permitted = res.Permitted && p.Permitted

		if p.Filter != "" {
			filters = append(filters, p.Filter)
		}

		for _, fld := range p.UnallowedFields {
			if !data.Contains(fld, res.UnallowedFields) {
				res.UnallowedFields = append(res.UnallowedFields, fld)
			}
		}
	}

	res.Filter = expr.And(data.SetFromSlice(filters)...)

	return res
}

func (p Permission) RemoveFields(in map[string]interface{}) map[string]interface{} {
	if in == nil {
		return nil
	}
	out := make(map[string]interface{})
	for k, v := range in {
		if data.Contains(k, p.UnallowedFields) {
			continue
		}
		out[k] = v
	}
	return out
}
