package organizations

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

type Storage interface {
	Create(ctx context.Context, org *Organization) (created *Organization, err error)
	Find(ctx context.Context, filter *Filter, opts *options.FindOptions) (orgs []*Organization, total int, err error)
	Delete(ctx context.Context, filter *Filter) (total int, err error)
	Update(ctx context.Context, update *Organization, filter *Filter) (updated, total int, err error)

	Reset(ctx context.Context) error
	Init(ctx context.Context) error
}
