package organizations

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

// @microgen grpc
// @protobuf git.perx.ru/perxis/perxis-go/proto/organizations
// @grpc-addr account.organizations.Organizations
type Organizations interface {
	Create(ctx context.Context, org *Organization) (created *Organization, err error)

	Get(ctx context.Context, orgId string) (org *Organization, err error)
	Update(ctx context.Context, org *Organization) (err error)
	Delete(ctx context.Context, orgId string) (err error)
	Find(ctx context.Context, filter *Filter, opts *options.FindOptions) (orgs []*Organization, total int, err error)
}

// Organizations
type Filter struct {
	ID   []string
	Name []string
}
