// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/telemetry
// gowrap: http://github.com/hexdigest/gowrap

package middleware

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/organizations -i Organizations -t ../../../assets/templates/middleware/telemetry -o telemetry_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
	"git.perx.ru/perxis/perxis-go/pkg/organizations"
	"go.opentelemetry.io/otel"
	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/trace"
)

// telemetryMiddleware implements organizations.Organizations interface instrumented with opentracing spans
type telemetryMiddleware struct {
	organizations.Organizations
	_instance      string
	_spanDecorator func(span trace.Span, params, results map[string]interface{})
}

// TelemetryMiddleware returns telemetryMiddleware
func TelemetryMiddleware(base organizations.Organizations, instance string, spanDecorator ...func(span trace.Span, params, results map[string]interface{})) telemetryMiddleware {
	d := telemetryMiddleware{
		Organizations: base,
		_instance:     instance,
	}

	if len(spanDecorator) > 0 && spanDecorator[0] != nil {
		d._spanDecorator = spanDecorator[0]
	}

	return d
}

// Create implements organizations.Organizations
func (_d telemetryMiddleware) Create(ctx context.Context, org *organizations.Organization) (created *organizations.Organization, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Organizations.Create")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx": ctx,
				"org": org}, map[string]interface{}{
				"created": created,
				"err":     err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Organizations.Create(ctx, org)
}

// Delete implements organizations.Organizations
func (_d telemetryMiddleware) Delete(ctx context.Context, orgId string) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Organizations.Delete")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":   ctx,
				"orgId": orgId}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Organizations.Delete(ctx, orgId)
}

// Find implements organizations.Organizations
func (_d telemetryMiddleware) Find(ctx context.Context, filter *organizations.Filter, opts *options.FindOptions) (orgs []*organizations.Organization, total int, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Organizations.Find")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":    ctx,
				"filter": filter,
				"opts":   opts}, map[string]interface{}{
				"orgs":  orgs,
				"total": total,
				"err":   err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Organizations.Find(ctx, filter, opts)
}

// Get implements organizations.Organizations
func (_d telemetryMiddleware) Get(ctx context.Context, orgId string) (org *organizations.Organization, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Organizations.Get")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":   ctx,
				"orgId": orgId}, map[string]interface{}{
				"org": org,
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Organizations.Get(ctx, orgId)
}

// Update implements organizations.Organizations
func (_d telemetryMiddleware) Update(ctx context.Context, org *organizations.Organization) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Organizations.Update")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx": ctx,
				"org": org}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Organizations.Update(ctx, org)
}
