package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/error_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/organizations -i Organizations -t ../../../assets/templates/middleware/error_log -o error_logging_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
	"git.perx.ru/perxis/perxis-go/pkg/organizations"
	"go.uber.org/zap"
)

// errorLoggingMiddleware implements organizations.Organizations that is instrumented with logging
type errorLoggingMiddleware struct {
	logger *zap.Logger
	next   organizations.Organizations
}

// ErrorLoggingMiddleware instruments an implementation of the organizations.Organizations with simple logging
func ErrorLoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next organizations.Organizations) organizations.Organizations {
		return &errorLoggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *errorLoggingMiddleware) Create(ctx context.Context, org *organizations.Organization) (created *organizations.Organization, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Create(ctx, org)
}

func (m *errorLoggingMiddleware) Delete(ctx context.Context, orgId string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Delete(ctx, orgId)
}

func (m *errorLoggingMiddleware) Find(ctx context.Context, filter *organizations.Filter, opts *options.FindOptions) (orgs []*organizations.Organization, total int, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Find(ctx, filter, opts)
}

func (m *errorLoggingMiddleware) Get(ctx context.Context, orgId string) (org *organizations.Organization, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Get(ctx, orgId)
}

func (m *errorLoggingMiddleware) Update(ctx context.Context, org *organizations.Organization) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Update(ctx, org)
}
