package middleware

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/cache"
	"git.perx.ru/perxis/perxis-go/pkg/options"
	service "git.perx.ru/perxis/perxis-go/pkg/organizations"
)

func CachingMiddleware(cache *cache.Cache) Middleware {
	return func(next service.Organizations) service.Organizations {
		return &cachingMiddleware{
			cache: cache,
			next:  next,
		}
	}
}

type cachingMiddleware struct {
	cache *cache.Cache
	next  service.Organizations
}

func (m cachingMiddleware) Create(ctx context.Context, org *service.Organization) (organization *service.Organization, err error) {
	return m.next.Create(ctx, org)
}

func (m cachingMiddleware) Get(ctx context.Context, orgId string) (organization *service.Organization, err error) {

	value, e := m.cache.Get(orgId)
	if e == nil {
		return value.(*service.Organization), err
	}
	organization, err = m.next.Get(ctx, orgId)
	if err == nil {
		m.cache.Set(orgId, organization)
	}
	return organization, err
}

func (m cachingMiddleware) Update(ctx context.Context, org *service.Organization) (err error) {

	err = m.next.Update(ctx, org)
	if err == nil {
		m.cache.Remove(org.ID)
	}
	return err
}

func (m cachingMiddleware) Delete(ctx context.Context, orgId string) (err error) {

	err = m.next.Delete(ctx, orgId)
	if err == nil {
		m.cache.Remove(orgId)
	}
	return err
}

func (m cachingMiddleware) Find(ctx context.Context, filter *service.Filter, opts *options.FindOptions) (organizations []*service.Organization, total int, err error) {
	return m.next.Find(ctx, filter, opts)
}
