package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../../assets/templates/middleware/access_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/members/observer -i Observer -t ../../../../assets/templates/middleware/access_log -o logging_middleware.go -l ""

import (
	"context"
	"fmt"
	"time"

	"git.perx.ru/perxis/perxis-go/pkg/auth"
	"git.perx.ru/perxis/perxis-go/pkg/collaborators"
	"git.perx.ru/perxis/perxis-go/pkg/members/observer"
	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"
)

// loggingMiddleware implements observer.Observer that is instrumented with logging
type loggingMiddleware struct {
	logger *zap.Logger
	next   observer.Observer
}

// LoggingMiddleware instruments an implementation of the observer.Observer with simple logging
func LoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next observer.Observer) observer.Observer {
		return &loggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *loggingMiddleware) OnCollaboratorSet(ctx context.Context, collaborator *collaborators.Collaborator) (delayedTaskID string, err error) {
	begin := time.Now()
	var fields []zapcore.Field
	for k, v := range map[string]interface{}{
		"ctx":          ctx,
		"collaborator": collaborator} {
		if k == "ctx" {
			fields = append(fields, zap.String("principal", fmt.Sprint(auth.GetPrincipal(ctx))))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("OnCollaboratorSet.Request", fields...)

	delayedTaskID, err = m.next.OnCollaboratorSet(ctx, collaborator)

	fields = []zapcore.Field{
		zap.Duration("time", time.Since(begin)),
	}

	for k, v := range map[string]interface{}{
		"delayedTaskID": delayedTaskID,
		"err":           err} {
		if k == "err" {
			err, _ := v.(error)
			fields = append(fields, zap.Error(err))
			continue
		}
		fields = append(fields, zap.Reflect(k, v))
	}

	m.logger.Debug("OnCollaboratorSet.Response", fields...)

	return delayedTaskID, err
}
