package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../../assets/templates/middleware/error_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/members/observer -i Observer -t ../../../../assets/templates/middleware/error_log -o error_logging_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/collaborators"
	"git.perx.ru/perxis/perxis-go/pkg/members/observer"
	"go.uber.org/zap"
)

// errorLoggingMiddleware implements observer.Observer that is instrumented with logging
type errorLoggingMiddleware struct {
	logger *zap.Logger
	next   observer.Observer
}

// ErrorLoggingMiddleware instruments an implementation of the observer.Observer with simple logging
func ErrorLoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next observer.Observer) observer.Observer {
		return &errorLoggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *errorLoggingMiddleware) OnCollaboratorSet(ctx context.Context, collaborator *collaborators.Collaborator) (delayedTaskID string, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.OnCollaboratorSet(ctx, collaborator)
}
