package middleware

// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/error_log
// gowrap: http://github.com/hexdigest/gowrap

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/locales -i Locales -t ../../../assets/templates/middleware/error_log -o error_logging_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/locales"
	"go.uber.org/zap"
)

// errorLoggingMiddleware implements locales.Locales that is instrumented with logging
type errorLoggingMiddleware struct {
	logger *zap.Logger
	next   locales.Locales
}

// ErrorLoggingMiddleware instruments an implementation of the locales.Locales with simple logging
func ErrorLoggingMiddleware(logger *zap.Logger) Middleware {
	return func(next locales.Locales) locales.Locales {
		return &errorLoggingMiddleware{
			next:   next,
			logger: logger,
		}
	}
}

func (m *errorLoggingMiddleware) Create(ctx context.Context, locale *locales.Locale) (created *locales.Locale, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Create(ctx, locale)
}

func (m *errorLoggingMiddleware) Delete(ctx context.Context, spaceId string, localeId string) (err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.Delete(ctx, spaceId, localeId)
}

func (m *errorLoggingMiddleware) List(ctx context.Context, spaceId string) (locales []*locales.Locale, err error) {
	logger := m.logger
	defer func() {
		if err != nil {
			logger.Warn("response error", zap.Error(err))
		}
	}()
	return m.next.List(ctx, spaceId)
}
