package middleware

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/cache"
	service "git.perx.ru/perxis/perxis-go/pkg/locales"
)

func CachingMiddleware(cache *cache.Cache) Middleware {
	return func(next service.Locales) service.Locales {
		return &cachingMiddleware{
			cache: cache,
			next:  next,
		}
	}
}

type cachingMiddleware struct {
	cache *cache.Cache
	next  service.Locales
}

func (m cachingMiddleware) Create(ctx context.Context, locale *service.Locale) (loc *service.Locale, err error) {

	loc, err = m.next.Create(ctx, locale)
	if err == nil {
		m.cache.Remove(loc.SpaceID)
	}
	return loc, err
}

func (m cachingMiddleware) List(ctx context.Context, spaceId string) (locales []*service.Locale, err error) {

	value, e := m.cache.Get(spaceId)
	if e == nil {
		return value.([]*service.Locale), err
	}
	locales, err = m.next.List(ctx, spaceId)
	if err == nil {
		m.cache.Set(spaceId, locales)
	}
	return locales, err
}

func (m cachingMiddleware) Delete(ctx context.Context, spaceId string, localeId string) (err error) {

	err = m.next.Delete(ctx, spaceId, localeId)
	if err == nil {
		m.cache.Remove(spaceId)
	}
	return err
}
