package transportgrpc

import (
	grpcerr "git.perx.ru/perxis/perxis-go/pkg/errors/grpc"
	"git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/items/transport"
	pb "git.perx.ru/perxis/perxis-go/proto/items"
	grpckit "github.com/go-kit/kit/transport/grpc"
)

func NewServer(svc items.Items, opts ...grpckit.ServerOption) pb.ItemsServer {
	eps := transport.Endpoints(svc)
	eps = transport.EndpointsSet{
		CreateEndpoint:             grpcerr.ServerMiddleware(eps.CreateEndpoint),
		IntrospectEndpoint:         grpcerr.ServerMiddleware(eps.IntrospectEndpoint),
		GetEndpoint:                grpcerr.ServerMiddleware(eps.GetEndpoint),
		FindEndpoint:               grpcerr.ServerMiddleware(eps.FindEndpoint),
		UpdateEndpoint:             grpcerr.ServerMiddleware(eps.UpdateEndpoint),
		DeleteEndpoint:             grpcerr.ServerMiddleware(eps.DeleteEndpoint),
		UndeleteEndpoint:           grpcerr.ServerMiddleware(eps.UndeleteEndpoint),
		PublishEndpoint:            grpcerr.ServerMiddleware(eps.PublishEndpoint),
		UnpublishEndpoint:          grpcerr.ServerMiddleware(eps.UnpublishEndpoint),
		GetPublishedEndpoint:       grpcerr.ServerMiddleware(eps.GetPublishedEndpoint),
		FindPublishedEndpoint:      grpcerr.ServerMiddleware(eps.FindPublishedEndpoint),
		GetRevisionEndpoint:        grpcerr.ServerMiddleware(eps.GetRevisionEndpoint),
		ListRevisionsEndpoint:      grpcerr.ServerMiddleware(eps.ListRevisionsEndpoint),
		ArchiveEndpoint:            grpcerr.ServerMiddleware(eps.ArchiveEndpoint),
		FindArchivedEndpoint:       grpcerr.ServerMiddleware(eps.FindArchivedEndpoint),
		UnarchiveEndpoint:          grpcerr.ServerMiddleware(eps.UnarchiveEndpoint),
		AggregateEndpoint:          grpcerr.ServerMiddleware(eps.AggregateEndpoint),
		AggregatePublishedEndpoint: grpcerr.ServerMiddleware(eps.AggregatePublishedEndpoint),
	}
	return NewGRPCServer(&eps, opts...)
}
