package items

import (
	"context"
)

type ItemObserver interface{}

type ItemReadObserver interface {
	OnPreGet(ctx context.Context, spaceId, envId, collectionId, itemId string) error
	OnPostGet(ctx context.Context, item *Item) (*Item, error)
	OnPreFind(ctx context.Context, spaceId, envId, collectionId string, filter *Filter, options *FindOptions) error
	OnPostFind(ctx context.Context, items []*Item, total int) ([]*Item, int, error)
}
