// Code generated by gowrap. DO NOT EDIT.
// template: ../../../assets/templates/middleware/telemetry
// gowrap: http://github.com/hexdigest/gowrap

package middleware

//go:generate gowrap gen -p git.perx.ru/perxis/perxis-go/pkg/items -i Items -t ../../../assets/templates/middleware/telemetry -o telemetry_middleware.go -l ""

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/items"
	"git.perx.ru/perxis/perxis-go/pkg/schema"
	"go.opentelemetry.io/otel"
	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/trace"
)

// telemetryMiddleware implements items.Items interface instrumented with opentracing spans
type telemetryMiddleware struct {
	items.Items
	_instance      string
	_spanDecorator func(span trace.Span, params, results map[string]interface{})
}

// TelemetryMiddleware returns telemetryMiddleware
func TelemetryMiddleware(base items.Items, instance string, spanDecorator ...func(span trace.Span, params, results map[string]interface{})) telemetryMiddleware {
	d := telemetryMiddleware{
		Items:     base,
		_instance: instance,
	}

	if len(spanDecorator) > 0 && spanDecorator[0] != nil {
		d._spanDecorator = spanDecorator[0]
	}

	return d
}

// Aggregate implements items.Items
func (_d telemetryMiddleware) Aggregate(ctx context.Context, spaceId string, envId string, collectionId string, filter *items.Filter, options ...*items.AggregateOptions) (result map[string]interface{}, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Aggregate")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"filter":       filter,
				"options":      options}, map[string]interface{}{
				"result": result,
				"err":    err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Aggregate(ctx, spaceId, envId, collectionId, filter, options...)
}

// AggregatePublished implements items.Items
func (_d telemetryMiddleware) AggregatePublished(ctx context.Context, spaceId string, envId string, collectionId string, filter *items.Filter, options ...*items.AggregatePublishedOptions) (result map[string]interface{}, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.AggregatePublished")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"filter":       filter,
				"options":      options}, map[string]interface{}{
				"result": result,
				"err":    err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.AggregatePublished(ctx, spaceId, envId, collectionId, filter, options...)
}

// Archive implements items.Items
func (_d telemetryMiddleware) Archive(ctx context.Context, item *items.Item, options ...*items.ArchiveOptions) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Archive")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"item":    item,
				"options": options}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Archive(ctx, item, options...)
}

// Create implements items.Items
func (_d telemetryMiddleware) Create(ctx context.Context, item *items.Item, opts ...*items.CreateOptions) (created *items.Item, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Create")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":  ctx,
				"item": item,
				"opts": opts}, map[string]interface{}{
				"created": created,
				"err":     err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Create(ctx, item, opts...)
}

// Delete implements items.Items
func (_d telemetryMiddleware) Delete(ctx context.Context, item *items.Item, options ...*items.DeleteOptions) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Delete")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"item":    item,
				"options": options}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Delete(ctx, item, options...)
}

// Find implements items.Items
func (_d telemetryMiddleware) Find(ctx context.Context, spaceId string, envId string, collectionId string, filter *items.Filter, options ...*items.FindOptions) (items []*items.Item, total int, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Find")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"filter":       filter,
				"options":      options}, map[string]interface{}{
				"items": items,
				"total": total,
				"err":   err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Find(ctx, spaceId, envId, collectionId, filter, options...)
}

// FindArchived implements items.Items
func (_d telemetryMiddleware) FindArchived(ctx context.Context, spaceId string, envId string, collectionId string, filter *items.Filter, options ...*items.FindArchivedOptions) (items []*items.Item, total int, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.FindArchived")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"filter":       filter,
				"options":      options}, map[string]interface{}{
				"items": items,
				"total": total,
				"err":   err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.FindArchived(ctx, spaceId, envId, collectionId, filter, options...)
}

// FindPublished implements items.Items
func (_d telemetryMiddleware) FindPublished(ctx context.Context, spaceId string, envId string, collectionId string, filter *items.Filter, options ...*items.FindPublishedOptions) (items []*items.Item, total int, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.FindPublished")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"filter":       filter,
				"options":      options}, map[string]interface{}{
				"items": items,
				"total": total,
				"err":   err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.FindPublished(ctx, spaceId, envId, collectionId, filter, options...)
}

// Get implements items.Items
func (_d telemetryMiddleware) Get(ctx context.Context, spaceId string, envId string, collectionId string, itemId string, options ...*items.GetOptions) (item *items.Item, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Get")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"itemId":       itemId,
				"options":      options}, map[string]interface{}{
				"item": item,
				"err":  err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Get(ctx, spaceId, envId, collectionId, itemId, options...)
}

// GetPublished implements items.Items
func (_d telemetryMiddleware) GetPublished(ctx context.Context, spaceId string, envId string, collectionId string, itemId string, options ...*items.GetPublishedOptions) (item *items.Item, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.GetPublished")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"itemId":       itemId,
				"options":      options}, map[string]interface{}{
				"item": item,
				"err":  err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.GetPublished(ctx, spaceId, envId, collectionId, itemId, options...)
}

// GetRevision implements items.Items
func (_d telemetryMiddleware) GetRevision(ctx context.Context, spaceId string, envId string, collectionId string, itemId string, revisionId string, options ...*items.GetRevisionOptions) (item *items.Item, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.GetRevision")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"itemId":       itemId,
				"revisionId":   revisionId,
				"options":      options}, map[string]interface{}{
				"item": item,
				"err":  err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.GetRevision(ctx, spaceId, envId, collectionId, itemId, revisionId, options...)
}

// Introspect implements items.Items
func (_d telemetryMiddleware) Introspect(ctx context.Context, item *items.Item, opts ...*items.IntrospectOptions) (itm *items.Item, sch *schema.Schema, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Introspect")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":  ctx,
				"item": item,
				"opts": opts}, map[string]interface{}{
				"itm": itm,
				"sch": sch,
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Introspect(ctx, item, opts...)
}

// ListRevisions implements items.Items
func (_d telemetryMiddleware) ListRevisions(ctx context.Context, spaceId string, envId string, collectionId string, itemId string, options ...*items.ListRevisionsOptions) (items []*items.Item, err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.ListRevisions")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":          ctx,
				"spaceId":      spaceId,
				"envId":        envId,
				"collectionId": collectionId,
				"itemId":       itemId,
				"options":      options}, map[string]interface{}{
				"items": items,
				"err":   err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.ListRevisions(ctx, spaceId, envId, collectionId, itemId, options...)
}

// Publish implements items.Items
func (_d telemetryMiddleware) Publish(ctx context.Context, item *items.Item, options ...*items.PublishOptions) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Publish")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"item":    item,
				"options": options}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Publish(ctx, item, options...)
}

// Unarchive implements items.Items
func (_d telemetryMiddleware) Unarchive(ctx context.Context, item *items.Item, options ...*items.UnarchiveOptions) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Unarchive")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"item":    item,
				"options": options}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Unarchive(ctx, item, options...)
}

// Undelete implements items.Items
func (_d telemetryMiddleware) Undelete(ctx context.Context, item *items.Item, options ...*items.UndeleteOptions) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Undelete")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"item":    item,
				"options": options}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Undelete(ctx, item, options...)
}

// Unpublish implements items.Items
func (_d telemetryMiddleware) Unpublish(ctx context.Context, item *items.Item, options ...*items.UnpublishOptions) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Unpublish")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"item":    item,
				"options": options}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Unpublish(ctx, item, options...)
}

// Update implements items.Items
func (_d telemetryMiddleware) Update(ctx context.Context, item *items.Item, options ...*items.UpdateOptions) (err error) {
	ctx, _span := otel.Tracer(_d._instance).Start(ctx, "Items.Update")
	defer func() {
		if _d._spanDecorator != nil {
			_d._spanDecorator(_span, map[string]interface{}{
				"ctx":     ctx,
				"item":    item,
				"options": options}, map[string]interface{}{
				"err": err})
		} else if err != nil {
			_span.RecordError(err)
			_span.SetAttributes(attribute.String("event", "error"))
			_span.SetAttributes(attribute.String("message", err.Error()))
		}

		_span.End()
	}()
	return _d.Items.Update(ctx, item, options...)
}
