package items

import (
	"git.perx.ru/perxis/perxis-go/pkg/errors"
	pb "git.perx.ru/perxis/perxis-go/proto/items"
	"github.com/golang/protobuf/proto"
)

const (
	EventCreateItem    = "create_item"
	EventUpdateItem    = "update_item"
	EventPublishItem   = "publish_item"
	EventUnpublishItem = "unpublish_item"
	EventDeleteItem    = "delete_item"

	DefaultEventSubject = "content.{{.EventType}}.{{.SpaceID}}.{{.EnvID}}.{{.CollectionID}}.{{.ItemID}}"
)

var (
	ErrInvalidEventType = func(expected string, got any) error {
		return errors.Errorf("invalid message type: expected '%s', got '%t'", expected, got)
	}
)

type EventCreate struct {
	SpaceID      string
	EnvID        string
	CollectionID string
	ItemID       string
}

func (e EventCreate) ToProto() (proto.Message, error) {
	return &pb.EventCreate{SpaceId: e.SpaceID, EnvId: e.EnvID, CollectionId: e.CollectionID, ItemId: e.ItemID}, nil
}

func (e *EventCreate) FromProto(message proto.Message) error {
	p, ok := message.(*pb.EventCreate)
	if !ok {
		return ErrInvalidEventType("*pb.EventCreate", message)
	}

	e.SpaceID = p.SpaceId
	e.EnvID = p.EnvId
	e.CollectionID = p.CollectionId
	e.ItemID = p.ItemId
	return nil
}

type EventUpdate struct {
	SpaceID      string
	EnvID        string
	CollectionID string
	ItemID       string
}

func (e EventUpdate) ToProto() (proto.Message, error) {
	return &pb.EventUpdate{SpaceId: e.SpaceID, EnvId: e.EnvID, CollectionId: e.CollectionID, ItemId: e.ItemID}, nil
}

func (e *EventUpdate) FromProto(message proto.Message) error {
	p, ok := message.(*pb.EventUpdate)
	if !ok {
		return ErrInvalidEventType("*pb.EventUpdate", message)
	}

	e.SpaceID = p.SpaceId
	e.EnvID = p.EnvId
	e.CollectionID = p.CollectionId
	e.ItemID = p.ItemId
	return nil
}

type EventPublish struct {
	SpaceID      string
	EnvID        string
	CollectionID string
	ItemID       string
}

func (e EventPublish) ToProto() (proto.Message, error) {
	return &pb.EventPublish{SpaceId: e.SpaceID, EnvId: e.EnvID, CollectionId: e.CollectionID, ItemId: e.ItemID}, nil
}

func (e *EventPublish) FromProto(message proto.Message) error {
	p, ok := message.(*pb.EventPublish)
	if !ok {
		return ErrInvalidEventType("*pb.EventPublish", message)
	}
	e.SpaceID = p.SpaceId
	e.EnvID = p.EnvId
	e.CollectionID = p.CollectionId
	e.ItemID = p.ItemId
	return nil
}

type EventUnpublish struct {
	SpaceID      string
	EnvID        string
	CollectionID string
	ItemID       string
}

func (e EventUnpublish) ToProto() (proto.Message, error) {
	return &pb.EventUnpublish{SpaceId: e.SpaceID, EnvId: e.EnvID, CollectionId: e.CollectionID, ItemId: e.ItemID}, nil
}

func (e *EventUnpublish) FromProto(message proto.Message) error {
	p, ok := message.(*pb.EventUnpublish)
	if !ok {
		return ErrInvalidEventType("*pb.EventUnpublish", message)
	}
	e.SpaceID = p.SpaceId
	e.EnvID = p.EnvId
	e.CollectionID = p.CollectionId
	e.ItemID = p.ItemId
	return nil
}

type EventDelete struct {
	SpaceID      string
	EnvID        string
	CollectionID string
	ItemID       string
}

func (e EventDelete) ToProto() (proto.Message, error) {
	return &pb.EventDelete{SpaceId: e.SpaceID, EnvId: e.EnvID, CollectionId: e.CollectionID, ItemId: e.ItemID}, nil
}

func (e *EventDelete) FromProto(message proto.Message) error {
	p, ok := message.(*pb.EventDelete)
	if !ok {
		return ErrInvalidEventType("*pb.EventDelete", message)
	}
	e.SpaceID = p.SpaceId
	e.EnvID = p.EnvId
	e.CollectionID = p.CollectionId
	e.ItemID = p.ItemId
	return nil
}
