package invitations

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

type Storage interface {
	Init(ctx context.Context) error
	Reset(ctx context.Context) error

	Create(ctx context.Context, create *Invitation) (invitation *Invitation, err error)
	Find(ctx context.Context, filter *Filter, opts *options.FindOptions) (invitations []*Invitation, total int, err error)
	Delete(ctx context.Context, filter *Filter) (total int, err error)
	Update(ctx context.Context, update *Invitation, filter *Filter) (updated, total int, err error)
}
