package invitations

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/options"
)

type Filter struct {
	ID      []string
	Email   []string
	OrgID   []string
	SpaceID []string
	OwnerID []string
	Role    []string
}

// @microgen grpc
// @protobuf git.perx.ru/perxis/perxis-go/proto/invitations
// @grpc-addr content.invitations.Invitations
type Invitations interface {
	Create(ctx context.Context, invitation *Invitation) (created *Invitation, err error)
	Get(ctx context.Context, invitationId string) (invitation *Invitation, err error)
	Accept(ctx context.Context, invitationId, userId string) (err error)
	Find(ctx context.Context, filter *Filter, opts *options.FindOptions) (invitations []*Invitation, total int, err error)
	Delete(ctx context.Context, invitationId string) (err error)
}
