package middleware

import (
	"context"

	"git.perx.ru/perxis/perxis-go/pkg/cache"
	service "git.perx.ru/perxis/perxis-go/pkg/invitations"
	services "git.perx.ru/perxis/perxis-go/pkg/options"
)

func CachingMiddleware(cache *cache.Cache) Middleware {
	return func(next service.Invitations) service.Invitations {
		return &cachingMiddleware{
			cache: cache,
			next:  next,
		}
	}
}

type cachingMiddleware struct {
	cache *cache.Cache
	next  service.Invitations
}

func (m cachingMiddleware) Create(ctx context.Context, invitation *service.Invitation) (inv *service.Invitation, err error) {
	return m.next.Create(ctx, invitation)
}

func (m cachingMiddleware) Get(ctx context.Context, invitationId string) (inv *service.Invitation, err error) {

	value, e := m.cache.Get(invitationId)
	if e == nil {
		return value.(*service.Invitation), err
	}
	inv, err = m.next.Get(ctx, invitationId)
	if err == nil {
		m.cache.Set(invitationId, inv)
	}
	return inv, err
}

func (m cachingMiddleware) Accept(ctx context.Context, invitationId string, userId string) (err error) {

	err = m.next.Accept(ctx, invitationId, userId)
	if err == nil {
		m.cache.Remove(invitationId)
	}
	return err
}

func (m cachingMiddleware) Find(ctx context.Context, filter *service.Filter, opts *services.FindOptions) (invitations []*service.Invitation, total int, err error) {
	return m.next.Find(ctx, filter, opts)
}

func (m cachingMiddleware) Delete(ctx context.Context, invitationId string) (err error) {

	err = m.next.Delete(ctx, invitationId)
	if err == nil {
		m.cache.Remove(invitationId)
	}
	return err
}
