package files

import (
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
)

type Uploader interface {
	Upload(src io.Reader, upload *Upload) error
}

type uploader struct{}

func NewUploader() Uploader {
	return &uploader{}
}

func (u *uploader) Upload(src io.Reader, upload *Upload) error {

	req, err := http.NewRequest(http.MethodPut, upload.UploadURL, src)
	if err != nil {
		return err
	}

	req.ContentLength = int64(upload.Size)
	req.Header.Set("Content-Disposition", fmt.Sprintf("attachment; filename*=UTF-8''%s;", url.PathEscape(upload.Name)))
	req.Header.Set("Content-Type", upload.MimeType)

	resp, err := http.DefaultClient.Do(req)
	if err != nil {
		return err
	}

	if resp.StatusCode != http.StatusOK {
		return errors.New("upload request failed: " + resp.Status)
	}

	return nil
}
