package files

import "context"

type Storage interface {
	// StartUpload - инициирует процедуру загрузки файла в файловое хранилище.
	// Используется клиентским приложением для начала загрузки файла
	StartUpload(ctx context.Context, upload *MultipartUpload) (*MultipartUpload, error)

	// CompleteUpload - завершает процедуру загрузки файла
	CompleteUpload(ctx context.Context, upload *MultipartUpload) (*MultipartUpload, error)

	// AbortUpload - прерывает процедуру загрузки файла, все загруженные части файла удаляются из хранилища
	AbortUpload(ctx context.Context, upload *MultipartUpload) error

	// Move - перемещает файл с ключом src.Key по новому пути dst.Key
	Move(ctx context.Context, src, dst *File) (*File, error)

	// Upload - одиночная загрузка файла в хранилище
	// Максимальный размер загружаемого файла - 5ГБ
	Upload(ctx context.Context, file *File) (*Upload, error)

	// GetFile - проверяет, существует ли файл в хранилище и
	// возвращает объект 'File' с заполненным URL
	GetFile(ctx context.Context, file *File) (f *File, err error)

	// DeleteFile - удаляет файл по ключу
	DeleteFile(ctx context.Context, file *File) error
}
