package files

import (
	"context"
)

// Files - описывает интерфейс файлового сервиса
// @microgen grpc, recovering, middleware
// @protobuf git.perx.ru/perxis/perxis-go/proto/files
// @grpc-addr files.Files
type Files interface {
	// StartUpload - инициирует процедуру загрузки файла в файловое хранилище.
	// Используется клиентским приложением для начала загрузки файла
	StartUpload(ctx context.Context, upload *MultipartUpload) (u *MultipartUpload, err error)

	// CompleteUpload - завершает процедуру загрузку файла
	CompleteUpload(ctx context.Context, upload *MultipartUpload) (u *MultipartUpload, err error)

	// AbortUpload - прерывает процедуру загрузки файла, все загруженные части файла удаляются их хранилища
	AbortUpload(ctx context.Context, upload *MultipartUpload) (err error)

	// MoveUpload - перемещает загруженный файл из временного расположения в постоянное месторасположения.
	// После перемещение загрузки хранилище выдает новый идентификатор постоянного файла
	MoveUpload(ctx context.Context, upload *MultipartUpload) (file *File, err error)

	// Upload - инициация загрузки файла в хранилище. Возвращает объект, содержащий подписанный URL.
	// Завершение загрузки файла осуществляется выполнением POST-запроса
	Upload(ctx context.Context, file *File) (u *Upload, err error)

	// GetFile - получить объект файла
	GetFile(ctx context.Context, file *File) (f *File, err error)

	// DeleteFile - удаляет файл. Если происходит удаление оригинала,
	// удаляются и все связанные структуры
	DeleteFile(ctx context.Context, file *File) (err error)
}
