package expr

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestIContains(t *testing.T) {
	tests := []struct {
		name string
		s1   interface{}
		s2   interface{}
		want bool
	}{
		{name: "nil#1", s1: nil, s2: nil, want: false},
		{name: "nil#2", s1: nil, s2: "hello", want: false},
		{name: "nil#3", s1: "hello", s2: nil, want: false},
		{name: "notstring#1", s1: map[string]interface{}{"a1": []interface{}{"a", "b"}}, s2: "hello", want: false},
		{name: "notstring#2", s1: 1, s2: "hello", want: false},
		{name: "correct#1", s1: "Abc", s2: "abc", want: true},
		{name: "correct#2", s1: "HELLO", s2: "hello", want: true},
		{name: "correct#3", s1: "abcDeFGh", s2: "dEFg", want: true},
		{name: "correct#4", s1: "heLLOworLD", s2: "ORL", want: true},
		{name: "incorrect#1", s1: "HELLO", s2: "elloo", want: false},
		{name: "incorrect#2", s1: "world", s2: "Word", want: false},
		{name: "incorrect#3", s1: "heLLOworLD", s2: "OOo", want: false},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			assert.Equalf(t, tt.want, IContains(tt.s1, tt.s2), "Icontains(%v, %v)", tt.s1, tt.s2)
		})
	}
}

func TestIEndsWith(t *testing.T) {
	tests := []struct {
		name string
		s1   interface{}
		s2   interface{}
		want bool
	}{
		{name: "nil#1", s1: nil, s2: nil, want: false},
		{name: "nil#2", s1: nil, s2: "hello", want: false},
		{name: "nil#3", s1: "hello", s2: nil, want: false},
		{name: "notstring#1", s1: map[string]interface{}{"a1": []interface{}{"a", "b"}}, s2: "hello", want: false},
		{name: "notstring#2", s1: 1, s2: "hello", want: false},
		{name: "correct#1", s1: "helloabc", s2: "Abc", want: true},
		{name: "correct#2", s1: "worldhello", s2: "HELLO", want: true},
		{name: "correct#3", s1: "abcDeFGh", s2: "FGH", want: true},
		{name: "incorrect#1", s1: "ello", s2: "HeLLo", want: false},
		{name: "incorrect#2", s1: "Word", s2: "world", want: false},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			assert.Equalf(t, tt.want, IEndsWith(tt.s1, tt.s2), "IendsWith(%v, %v)", tt.s1, tt.s2)
		})
	}
}

func TestIStartsWith(t *testing.T) {
	tests := []struct {
		name string
		s1   interface{}
		s2   interface{}
		want bool
	}{
		{name: "nil#1", s1: nil, s2: nil, want: false},
		{name: "nil#2", s1: nil, s2: "hello", want: false},
		{name: "nil#3", s1: "hello", s2: nil, want: false},
		{name: "notstring#1", s1: map[string]interface{}{"a1": []interface{}{"a", "b"}}, s2: "hello", want: false},
		{name: "notstring#2", s1: 1, s2: "hello", want: false},
		{name: "correct#1", s1: "helloabc", s2: "he", want: true},
		{name: "correct#2", s1: "worldhello", s2: "WOR", want: true},
		{name: "correct#3", s1: "abcDeFGh", s2: "ABC", want: true},
		{name: "incorrect#1", s1: "ello", s2: "HeLLo", want: false},
		{name: "incorrect#2", s1: "Word", s2: "world", want: false},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			assert.Equalf(t, tt.want, IStartsWith(tt.s1, tt.s2), "IstartsWith(%v, %v)", tt.s1, tt.s2)
		})
	}
}
