package expr

import (
	"fmt"
	"strings"
	"time"
)

func EqualString(f, s string) string {
	return fmt.Sprintf("%s == '%s'", f, s)
}

func NotEqualString(f, s string) string {
	return fmt.Sprintf("%s != '%s'", f, s)
}

func EqualNumber(f string, n int) string {
	return fmt.Sprintf("%s == %d", f, n)
}

func NotEqualNumber(f string, n int) string {
	return fmt.Sprintf("%s != %d", f, n)
}

func LessOrEqualNumber(f string, n int) string {
	return fmt.Sprintf("%s <= %d", f, n)
}

func InStringArray(s string, arr []string) string {
	arrStr := "'" + strings.Join(arr, "','") + "'"
	return fmt.Sprintf("%s in [%s]", s, arrStr)
}

func NotInStringArray(s string, arr []string) string {
	arrStr := "'" + strings.Join(arr, "','") + "'"
	return fmt.Sprintf("%s not in [%s]", s, arrStr)
}

func And(ss ...string) string {
	return strings.Join(ss, " && ")
}

func Or(ss ...string) string {
	return strings.Join(ss, " || ")
}

func Not(s string) string {
	return "!" + s
}

func After(f string, t time.Time) string {
	return fmt.Sprintf("%s > Time.Time('%s')", f, t.Format(time.RFC3339))
}

func AfterOrEqual(f string, t time.Time) string {
	return fmt.Sprintf("%s >= Time.Time('%s')", f, t.Format(time.RFC3339))
}

func Before(f string, t time.Time) string {
	return fmt.Sprintf("%s < Time.Time('%s')", f, t.Format(time.RFC3339))
}

func BeforeOrEqual(f string, t time.Time) string {
	return fmt.Sprintf("%s <= Time.Time('%s')", f, t.Format(time.RFC3339))
}
