package expr

import "context"

type ctxKey struct{}

type exprCtx struct {
	Env map[string]interface{}
}

func getContext(ctx context.Context) (context.Context, *exprCtx) {
	if ctx != nil {
		if c, _ := ctx.Value(ctxKey{}).(*exprCtx); c != nil {
			return ctx, c
		}
	} else {
		ctx = context.Background()
	}

	c := &exprCtx{}
	ctx = context.WithValue(ctx, ctxKey{}, c)
	return ctx, c
}

func WithEnv(ctx context.Context, env map[string]interface{}) context.Context {
	ctx, c := getContext(ctx)

	if c.Env == nil {
		c.Env = make(map[string]interface{})
	}

	for k, v := range env {
		c.Env[k] = v
	}

	return ctx
}

func WithEnvKV(ctx context.Context, kv ...interface{}) context.Context {
	m := make(map[string]interface{})

	for i := 0; i < len(kv)/2; i++ {
		key, ok := kv[i].(string)
		if !ok {
			return nil
		}
		m[key] = kv[i+1]
	}

	return WithEnv(ctx, m)
}

func GetEnv(ctx context.Context) map[string]interface{} {
	ctx, c := getContext(ctx)
	return c.Env
}
