package expr

import (
	"github.com/antonmedv/expr"
	"github.com/antonmedv/expr/conf"
)

type ExprConfig struct {
	options []expr.Option
}

func (c *ExprConfig) RegisterOption(opt ...expr.Option) {
	c.options = append(c.options, opt...)
}

func (c *ExprConfig) GetConfig(e map[string]interface{}) *conf.Config {
	cfg := conf.New(e)

	cfg.Operators = make(map[string][]string)
	for _, opt := range c.options {
		opt(cfg)
	}

	return cfg
}

var defaultConfig *ExprConfig

func init() {
	defaultConfig = &ExprConfig{}
}

func RegisterOption(opt ...expr.Option) {
	defaultConfig.RegisterOption(opt...)
}

func GetDefaultConfig(e map[string]interface{}) *conf.Config {
	return defaultConfig.GetConfig(e)
}

//func GetDefaultEnv(e map[string]interface{}) map[string]interface{} {
//	return defaultConfig.GetEnv(e)
//}

func Extend(kv ...interface{}) expr.Option {
	e := make(map[string]interface{})
	i := 0
	for {
		if i+2 > len(kv) {
			break
		}
		k, v := kv[i], kv[i+1]
		name, kOk := k.(string)
		if !kOk {
			break
		}

		e[name] = v
		i += 2
	}
	return ExtendMap(e)
}

func ExtendMap(e map[string]interface{}) expr.Option {
	return func(c *conf.Config) {
		var env map[string]interface{}
		var ok bool
		if c.Env == nil {
			env = make(map[string]interface{})
		} else {
			if env, ok = c.Env.(map[string]interface{}); !ok {
				panic("only map expr environment is supported")
			}
		}
		for k, v := range e {
			if _, ok := env[k]; !ok {
				env[k] = v
			}
		}
		c.Strict = true
		c.MapEnv = true
		c.Env = env
		c.Types = conf.CreateTypesTable(c.Env)
	}
}
